dofile("scripts/LevelManager.lua");

LManager = LevelManager.create();

LManager:AddNewTable( 1, 4, 280, 300, "assets/images/table/redtable", "assets/images/food/item_mark3", "R" );

useFloAsServer = 0;
useWineTable = 0;
numMoodBoosts = 0;
numServers = 1;

-- Group 1

guest = LManager.GenGuest(female01);
guest.matchType = table1;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(1, 1, 6000);

-- Group 2

guest = LManager.GenGuest(male01);
guest.matchType = female04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = female01;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(2, 3, 15000);

-- Group 3

guest = LManager.GenGuest(female01);
guest.matchType = table1;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(4, 4, 23000);

-- Group 4

guest = LManager.GenGuest(male04);
guest.matchType = female04;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(5, 5, 45000);

-- Group 5

guest = LManager.GenGuest(female01);
guest.matchType = male01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = male04;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(6, 7, 77000);


LManager:AdjustGuestTolerance(150);

LManager:SetLevelSetting ("bridesmaidsDelay", 70000); 
LManager:SetLevelSetting ("bridesmaidsChance", 100);

-- Set up the Level Settings
LManager:SetLevelNumber(1,2);
LManager:SetLevelScores(1200, 2100);
LManager:SetLevelTime(300000);

LManager:SetMusic( "assets/audio/music/Big Band 2.ogg", "assets/audio/music/Disco Dance 1.ogg", "assets/audio/music/new_dance_2.ogg" );

-- Generate Game Object
gameObject = LManager:GenerateGameObject();

-- Generate Level Settings
levelSetting = LManager:GenerateLevelSettings();

-- Generate Level Dialog
dofile( "scripts/LevelDialogGenerator.lua" );


TutorialSteps =
{
	start =
	{
		action = function()
		end,
		triggers = 
		{
			[1] = { condition = "CLOSE_QUINN_TALK_BUBBLE", parameter = "", next = "ShowTheHint" },
		},
	},
	
	ShowTheHint =
	{
		action = function()
			TextBox(470, 260, "tutorialStep18", 10000);
		end,
		triggers = 
		{
			[1] = { condition = "REQUEST_DESIRE", parameter = "WANT_SIT", next = "Done" },
		},
	},
		
	Done = 
	{
		action = function()
			HideTextBox();
			HideArrows();
		end,
		triggers =
		{
		}
	}
}


